//c clamp
//m.miller 05.03.23


// -----------------------------------------------------------------------------------------
//                      C L A M P 
//------------------------------------------------------------------------------------------ 
#include "shapes3.inc"


#declare M_body = material {M_steel_black_rough scale <.01,.01,.01>}

#macro coil (radA,radB,turns,h,objType)
  
    #declare sPoint = sphere {<0,0,0>, radB }                              
    #declare pointDataCount = 24 ;
    #declare pointArray = array[pointDataCount] ;
    #declare pointArray[0] = <0.000, 0.000, 1.000>  ;
    #declare pointArray[1] = <-0.258, 0.000, 0.965>  ;
    #declare pointArray[2] = <-0.500, 0.000, 0.866>  ;
    #declare pointArray[3] = <-0.707, 0.000, 0.707>  ;
    #declare pointArray[4] = <-0.866, 0.000, 0.500>  ;
    #declare pointArray[5] = <-0.965, 0.000, 0.258>  ;
    #declare pointArray[6] = <-1.000, 0.000, 0.000>  ;
    #declare pointArray[7] = <-0.965, 0.000, -0.258>  ;
    #declare pointArray[8] = <-0.866, 0.000, -0.500>  ;
    #declare pointArray[9] = <-0.707, 0.000, -0.707>  ;
    #declare pointArray[10] = <-0.500, 0.000, -0.866>  ;
    #declare pointArray[11] = <-0.258, 0.000, -0.965>  ;
    #declare pointArray[12] = <0.000, 0.000, -1.000>  ;
    #declare pointArray[13] = <0.258, 0.000, -0.965>  ;
    #declare pointArray[14] = <0.500, 0.000, -0.866>  ;
    #declare pointArray[15] = <0.707, 0.000, -0.707>  ;
    #declare pointArray[16] = <0.866, 0.000, -0.500>  ;
    #declare pointArray[17] = <0.965, 0.000, -0.258>  ;
    #declare pointArray[18] = <0.999, 0.000, 0.000>  ;
    #declare pointArray[19] = <0.965, 0.000, 0.258>  ;
    #declare pointArray[20] = <0.866, 0.000, 0.500>  ;
    #declare pointArray[21] = <0.707, 0.000, 0.707>  ;
    #declare pointArray[22] = <0.500, 0.000, 0.866>  ;
    #declare pointArray[23] = <0.258, 0.000, 0.965>  ; 
    
   
    #if (objType="plotCoil")
        #declare c=pointDataCount;
        #declare yOffset = h/(pointDataCount*turns);
        #declare cnt=0;
        sphere_sweep {
        cubic_spline
        c * turns,
        #declare j=0; 
        #while (j<turns)
            #declare i=0;
            #while (i<c) 
                #declare cnt=cnt+1;
                #declare pos = pointArray[i];
                #declare nY = (cnt*yOffset);
                #declare nPos = <pos.x,pos.y + nY,pos.z>;
                nPos * radA , radB
                #declare i=i+1;
            #end 
            #declare j=j+1;
        #end
        tolerance 0.000001
        }
    #end 
    
    #if (objType="plotPoints")
        #declare c=pointDataCount;
        #declare yOffset = h/(pointDataCount*turns);
        #declare cnt=0;
        #declare j=0; 
        #while (j<turns)
            #declare i=0;
            #while (i<c) 
                #declare cnt=cnt+1;
                #declare pos = pointArray[i];
                #declare nY = (cnt*yOffset);
                #declare nPos = <pos.x,pos.y + nY,pos.z>;
                object { sPoint translate nPos * radA }
                #declare i=i+1;
            #end 
            #declare j=j+1;
        #end
    #end 
#end

//--- C extrude
#declare C1 = 
prism {
    linear_spline
    -1, 1, 64,
    <-3.928,4.933>,
    <-8.443,4.933>,
    <-14.401,4.933>,
    <-17.872,4.933>,
    <-19.667,5.377>,
    <-20.698,6.133>,
    <-21.539,7.333>,
    <-21.917,8.978>,
    <-21.917,10.764>,
    <-21.917,17.250>,
    <-21.917,25.588>,
    <-21.917,33.829>,
    <-21.917,40.656>,
    <-21.917,47.507>,
    <-21.917,49.630>,
    <-21.557,51.198>,
    <-20.741,52.407>,
    <-19.614,53.223>,
    <-17.948,53.632>,
    <-14.872,53.632>,
    <-10.917,53.632>,
    <-8.330,53.632>,
    <-6.900,53.632>,
    <-6.095,52.906>,
    <-4.546,52.906>,
    <-1.607,52.906>,
    <1.489,52.906>,
    <4.448,52.906>,
    <5.235,52.996>,
    <5.680,53.464>,
    <5.600,54.795>,
    <5.104,55.679>,
    <2.001,57.789>,
    <-0.844,59.458>,
    <-4.254,61.128>,
    <-7.949,62.546>,
    <-11.378,63.444>,
    <-14.791,63.918>,
    <-18.384,64.071>,
    <-22.435,63.388>,
    <-26.009,61.201>,
    <-28.713,58.050>,
    <-30.251,54.988>,
    <-31.218,51.327>,
    <-31.476,49.000>,
    <-31.673,44.415>,
    <-31.673,38.630>,
    <-31.673,34.905>,
    <-31.673,29.393>,
    <-31.673,24.370>,
    <-31.673,18.500>,
    <-31.673,13.920>,
    <-31.673,9.743>,
    <-31.306,6.103>,
    <-29.366,1.517>,
    <-26.093,-1.833>,
    <-21.700,-3.711>,
    <-18.189,-4.168>,
    <-13.921,-4.168>,
    <-8.565,-4.168>,
    <-6.034,-4.168>,
    <-4.863,-4.331>,
    <-3.897,-4.753>
    <-3.928,4.933>
}


//--- C outline
#declare sz = 1;
#declare C2 =
sphere_sweep {
     cubic_spline
     65,
     <-3.928, 0.000, 4.933> , sz
     <-3.928, 0.000, 4.933> , sz
     <-8.443, 0.000, 4.933> , sz
     <-14.401, 0.000, 4.933> , sz
     <-17.872, 0.000, 4.933> , sz
     <-19.667, 0.000, 5.377> , sz
     <-20.698, 0.000, 6.133> , sz
     <-21.539, 0.000, 7.333> , sz
     <-21.917, 0.000, 8.978> , sz
     <-21.917, 0.000, 10.764> , sz
     <-21.917, 0.000, 17.250> , sz
     <-21.917, 0.000, 25.588> , sz
     <-21.917, 0.000, 33.829> , sz
     <-21.917, 0.000, 40.656> , sz
     <-21.917, 0.000, 47.507> , sz
     <-21.917, 0.000, 49.630> , sz
     <-21.557, 0.000, 51.198> , sz
     <-20.741, 0.000, 52.407> , sz
     <-19.614, 0.000, 53.223> , sz
     <-17.948, 0.000, 53.632> , sz
     <-14.872, 0.000, 53.632> , sz
     <-10.917, 0.000, 53.632> , sz
     <-8.330, 0.000, 53.632> , sz
     <-6.900, 0.000, 53.632> , sz
     <-6.095, 0.000, 52.906> , sz
     <-4.546, 0.000, 52.906> , sz
     <-1.607, 0.000, 52.906> , sz
     <1.489, 0.000, 52.906> , sz
     <4.448, 0.000, 52.906> , sz
     <5.235, 0.000, 52.996> , sz
     <5.680, 0.000, 53.464> , sz
     <5.600, 0.000, 54.795> , sz
     <5.104, 0.000, 55.679> , sz
     <2.001, 0.000, 57.789> , sz
     <-0.844, 0.000, 59.458> , sz
     <-4.254, 0.000, 61.128> , sz
     <-7.949, 0.000, 62.546> , sz
     <-11.378, 0.000, 63.444> , sz
     <-14.791, 0.000, 63.918> , sz
     <-18.384, 0.000, 64.071> , sz
     <-22.435, 0.000, 63.388> , sz
     <-26.009, 0.000, 61.201> , sz
     <-28.713, 0.000, 58.050> , sz
     <-30.251, 0.000, 54.988> , sz
     <-31.218, 0.000, 51.327> , sz
     <-31.476, 0.000, 49.000> , sz
     <-31.673, 0.000, 44.415> , sz
     <-31.673, 0.000, 38.630> , sz
     <-31.673, 0.000, 34.905> , sz
     <-31.673, 0.000, 29.393> , sz
     <-31.673, 0.000, 24.370> , sz
     <-31.673, 0.000, 18.500> , sz
     <-31.673, 0.000, 13.920> , sz
     <-31.673, 0.000, 9.743> , sz
     <-31.306, 0.000, 6.103> , sz
     <-29.366, 0.000, 1.517> , sz
     <-26.093, 0.000, -1.833> , sz
     <-21.700, 0.000, -3.711> , sz
     <-18.189, 0.000, -4.168> , sz
     <-13.921, 0.000, -4.168> , sz
     <-8.565, 0.000, -4.168> , sz
     <-6.034, 0.000, -4.168> , sz
     <-4.863, 0.000, -4.331> , sz
     <-3.897, 0.000, -4.753> , sz
     <-3.897, 0.000, -4.753> , sz
     tolerance 0.000001
     }


#declare Cstop =
#declare rad = .25 ;
union { 
    #declare sc = <6.799, 2.500, 1.195> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 0.000, 52.632> }
    material {M_body} 
}



#declare body =
object {
    union {
        object { C2 scale <1,2.5,1>}          //--- c shape raised outline
        difference {
            object { C1 scale <1,1.8,1> }     //--- c shape extrusion
            #declare rad = 1.7   ;
            #declare sc = <1.7, 3, 20.379> ;
            object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,1,2> translate <-26.880, 3, 29.155> } 
            }
    }
    material {M_body}
}



//cranck
#declare p1 = <5.337, 0, -11.649>  ;
#declare p2 = <-26.319, 0, -11.649>  ;
//crank post
#declare p3 = <0.000, 0, -14.866>  ;
#declare p4 = <0.000, 0, -8.736>  ;
//c-post 
#declare p5 = <0.000, 0.000, -5.8>  ;
#declare p6 =  <0.000, 0.000, 5.670>  ;

#declare turnPost =
union {
    union {
        cylinder {p1,p2,.92} 
        sphere {<0,0,0>, 1 scale <1,1.3,1.3> translate p1} 
        sphere {<0,0,0>, 1 scale <1,1.3,1.3> translate p2} 
        sphere {<0,0,0>, 1 scale <2,2,.4> translate p3}
        cylinder {p3,p4,2}
        translate <0,0,-9>
        material {M_steel_oxidized scale 3}
    } 
    cylinder {p5,p6,4.1  }
    sphere {<0,0,0>, 1 scale <4.1,4.1,.3> translate p5} 
    sphere {<0,0,0>, 1 scale <4.1,4.1,.3> translate p6} 
    material {M_body}
} 




#declare c_screwTip =
difference {
    cylinder {<0,0,0>,<0,0,3.25>,4.4}
    torus {4.3,2.1 rotate <90,0,0>}
    material {M_steel_oxidized  scale 3}
}




#declare c_threads = object { coil (1.7,.4,60,60,"plotCoil") material {M_steel_oxidized  scale 3} };




#declare c_clamp =
union { 
    object { body }
    object { Cstop }
    object { turnPost } 
    cylinder {<0,0,0>,<0,0,55>,1.7 translate <0,0,-18>}
    object { c_threads rotate <90,0,0> scale <1,1,.50> translate <0,0,-17>}
    object { c_screwTip translate <0,0,33>}
}
     
